﻿//////////////////////////////////////////////
// KeyboardDevice.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkInputs
{
	class System ;
}

/// Includes ---------------------------------

// nkInputs
#include "../../Dll/DllDefines.h"

#include "../../Enums/KeyCode.h"

// nkMemory
#include <NilkinsMemory/Pointers/UniquePtr.h>

/// Class ------------------------------------
	
namespace nkInputs
{
	class DLL_INPUTS_EXPORT KeyboardDevice
	{		
		public :
		
			// Constructor, destructor
			KeyboardDevice (System* system) noexcept ;
			virtual ~KeyboardDevice () ;

			// Getters
			System* getSystem () const ;
			virtual bool isKeyDown (KEY_CODE keyCode) = 0 ;

			// Update
			virtual void update () = 0 ;

		public :

			// Statics
			// Creation
			static nkMemory::UniquePtr<KeyboardDevice> create (System* system = nullptr) ;

		protected :

			System* _system ;
	} ;
}